//FIR.h

//sample frequency = 1 KHz
//filter order = 100
//normalized to 12 bit input and 12 bits output

/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/
#include "FslTypes.h"

/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/
#define FLT_ORDER                       (101)    //filter order
#define FLT_ENABLE
//#define DAC_ENABLE
//#define FLT_TIME_PIN

/************************************************************************************************/
/*                                Function Prototipes Section                                   */
/************************************************************************************************/
UINT32 u32MAC(INT32 *SamplePtr, INT32 *BuffEdge, INT32 *CoefPtr);
void PLL_Init(void);
void ADC_Init(void);
void DAC_Init(void);
//void TIMER2_Init(void);
void filter_execution(void);


/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/
extern INT32 ADC_Buffer[FLT_ORDER];  
extern volatile UINT16 wADCData;
extern UINT8 Index;
extern UINT32 FilterOutput;
extern volatile UINT32 OutDiv; 
extern volatile INT16 Offset;
extern UINT8 gu8FilterTimeElapsed;
extern INT32 BandPassCoef_4EKG[];   
